
<?php snippet('header') ?>

<?php if ($cover = $page->cover()): ?>
<a href="<?= $cover->url() ?>" data-lightbox class="img" style="--w:2; --h:1">
  <?= $cover->crop(500, 400) ?>
</a>
<?php endif ?>

<article class="note">
  <header class="note-header h1">
    <h1 class="note-title"><?= $page->title()->html() ?></h1>
    <?php if ($page->subheading()->isNotEmpty()): ?>
    <p class="note-subheading"><small><?= $page->subheading()->html() ?></small></p>
    <?php endif ?>
  </header>
    <time class="note-date" datetime="<?= $page->date('c') ?>">Du <?= $page->date_event_start() ?></time>
    <time class="note-date" datetime="<?= $page->date('c') ?>">au <?= $page->date_event_end() ?></time>
  <div class="note text">
    <?= $page->text()->kirbytext() ?>
  </div>
  <footer class="note-footer">
    <?php if (!empty($tags)): ?>
    <ul class="note-tags">
      <?php foreach ($tags as $tag): ?>
      <li>
        <a href="<?= $page->parent()->url(['params' => ['tag' => $tag]]) ?>"><?= html($tag) ?></a>
      </li>
      <?php endforeach ?>
    </ul>
    <?php endif ?>
  </footer>

  <!--<?php snippet('prevnext') ?>-->
</article>






RELATION ARTISTE 
<!-- RELATION: -->
            <?php 
        $images = array();
        $related = $page->related_artiste()->toPages();
    
        foreach($related as $r) {
            if(count(page($r)->children()) > 0) {
                foreach(page($r)->children() as $children) {
                    foreach($children->files() as $file) {
                        $images[] = $file;
                    }
                }
            } else if(count(page($r)->files()) > 0) {
                foreach(page($r)->files() as $file) {
                    $images[] = $file;
                }
            }
        }
        $images = array_unique($images)
    ?>
            <?php if(count($images)): ?>
            <?php foreach($images as $image): ?>
            <div class="col-12 col-sm-6 col-md-4 mb-4">
                <div class="card">

                    <?php if ($image->headline()->length() > 0): ?>
                    <button type="button" data-toggle="modal" data-target="#<?= strtolower(str_replace(' ', '-', $image->headline())) ?>">
                        <img class="img-fluid" src="<?= $image->crop(500, 270)->url() ?>" title="<?= $image->title() ?>" alt="<?= $image->alt() ?>">
                    </button>

                    <?php else: ?>
                        <img class="img-fluid" src="<?= $image->crop(500, 270)->url() ?>" title="<?= $image->title() ?>" alt="<?= $image->alt() ?>">
                    <?php endif ?>

                    <div class="card-body">
                        <?php if ($image->firstname()->length() > 0): ?>
                        <h5><?= $image->firstname() ?></h5>
                        <?php else: ?>
                        <h5>Non renseigné</h5>
                        <?php endif ?>
                    </div>

                </div>
            </div>
            <?php endforeach ?>
            <?php endif ?>


















<?php snippet('footer') ?>
