<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php snippet('header') ?>

<!--DEFAULT-->

<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>

                    <div class="col-md-12 d-flex align-items-center">
                        <div class="text ftco-animate">
                            <h1><?= $page->title()->html() ?></h1>
                            <?= $page->text()->kirbytext() ?>
                        </div>
                    </div>

                    <div class="col-md-12 d-flex align-items-center">
                        <?php

                        // nested menu
                        $items = $pages->published();

                        // only show the menu if items are available
                        if($items->isNotEmpty()):

                        ?>
                        <nav>
                            <ul>
                                <?php foreach($items as $item): ?>
                                <li>
                                    <a<?php e($item->isOpen(), ' class="active"') ?> href="<?= $item->url() ?>"><?= $item->title()->html() ?></a>

                                        <?php

                                      // get all children for the current menu item
                                      $children = $item->children()->listed();

                                      // display the submenu if the item is not blog or shop and if children are available
                                      if(! in_array($item->id(), ['blog', 'shop']) && $children->isNotEmpty()):

                                      ?>
                                        <ul>
                                            <?php foreach($children as $child): ?>
                                            <li>
                                                <a<?php e($child->isOpen(), ' class="active"') ?> href="<?= $child->url() ?>"><?= $child->title()->html() ?></a>
                                            </li>
                                            <?php endforeach ?>
                                        </ul>
                                      <?php endif ?>

                                </li>
                                <?php endforeach ?>
                            </ul>
                        </nav>
                        <?php endif ?>
                    </div>
                </div>

            </div>
        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
