<?php snippet('header') ?>

<!--PAGE BLOG-->
<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>

                    <div class="col-lg-8">
                        <h1 class="note-title"><?= $page->title()->html() ?></h1>

                        <?php if (!empty($tags)): ?>
                        
                            <?php foreach ($tags as $tag): ?>
                            
                                <a href="<?= $page->parent()->url(['params' => ['tag' => $tag]]) ?>" class="badge badge-light"><?= html($tag) ?></a>
                             
                            <?php endforeach ?>
                            <br/><br/>
                        <?php endif ?>
                        
                        <?php if ($page->subheading()->isNotEmpty()): ?>
                        <p class="note-subheading"><small><?= $page->subheading()->html() ?></small></p>
                        <?php endif ?>

                        <?= $page->text()->toBlocks() ?>

                        <div class="m-4">
                            <?php snippet('files/fichiers') ?>
                        </div>
                        
                        <time class="note-date" datetime="<?= $page->date('c') ?>">Publié: <?= $page->date()->toDate('%A %e %B à %H:%M') ?></time>

                   
                       
                       
                    </div>
                    <div class="col-lg-4">
                        <?php if ($page->hasImages()): ?>
                        <img src="<?= $site->url() ?>/<?= $page->images() ?>" width="100%" />
                           
                        <?php else: ?>
                            <img src="<?= $site->url() ?>/assets/images/logo.jpg" width="100%" />
                        <?php endif ?>
                    </div>



                </div>

            </div>
        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
