<?php snippet('header') ?>
<!--LISTING-->

<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>

                    <div class="col-md-12 d-flex align-items-center">
                        <div class="text ftco-animate">
                            <h1><?= $page->headline()->html() ?></h1>
                            <?= $page->text()->kirbytext() ?>
                        </div>
                    </div>

                    <!-- listing-->
                    <div class="col-lg pl-lg-5 pl-lg-0">

                        <h2 class="mb-4 text-uppercase pb_letter-spacing-2"><?= $page->titletable()->html() ?></h2>

                        <div class="input-group input-group-lg">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="inputGroup-sizing-lg">Recherche</span>
                            </div>
                            <input type="text" class="form-control" id="myInput" aria-label="Sizing example input" aria-describedby="inputGroup-sizing-lg" placeholder="Cherchez le nom d'une composition ...">
                        </div>
                        <br />
                        <?php foreach($page->listing()->toStructure()->pluck("category", ",", true) as $title): ?>
                            <input type="button" class="btn btn-primary mb-2" onclick="updateSearch('<?= html($title) ?>');" value="<?= html($title) ?>">
                        <?php endforeach ?>

                        <script>
                            function updateSearch(value) {
                                $('#myInput').val(value);
                                
                                var value = value.toLowerCase();
                                $("#myTable tr").filter(function() {
                                  $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                                });
                            }
                        </script>
                        <br /><br />
      
                        
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th scope="col" class="w-50">Composition</th>
                                        <th scope="col">Écoute</th>
                                    </tr>
                                </thead>
                                <tbody id="myTable">
                                    <?php foreach ($page->listing()->toStructure() as $listing): ?>
                                    <tr>
                                        <td>
                                            <b><?= $listing->name() ?></b><br />
                                            <?= $listing->category() ?><br />
                                            <?= $listing->description()->kirbytext() ?><br />

                                            <?php if(($page = $listing->related()->toPage()) ? $page->url() : ''): ?>
                                            En savoir plus: <a href="<?= ($page = $listing->related()->toPage()) ? $page->url() : '' ?>"><?= ($page = $listing->related()->toPage()) ? $page->title() : '' ?></a>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= $listing->player() ?></td>
                                    </tr>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>

            </div>
        </div><!-- END-->
    </div>
</section>






<?php snippet('footer') ?>
