<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php snippet('header') ?>

<!--BIOGRAPHY-->

<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row d-flex">


            <div class="col-xl-8 py-5 px-md-5">
                <div class="col-md-12 d-flex align-items-center">
                    <div class="text ftco-animate">
                        <h1><?= $page->headline()->html() ?></h1>
                    </div>
                </div>
                <div class="col-md-12 text ftco-animate">
                    <?= $page->text()->kirbytext() ?>
                </div>
                <div class="col-md-12 d-flex align-items-center">
                    <div class="row">
                        <?php snippet('files/images') ?>
                    </div>
                </div>
                <div class="col-md-12 text ftco-animate">

                    <p class="my-3 p-3 border border-primary text-primary text-center">
                        <i class="fas fa-quote-left"></i>
                        <?= $page->slogan()->html() ?>
                        <i class="fas fa-quote-right"></i>
                    </p>

                </div>

                <div class="col-md-12 text ftco-animate">
                    <?= $page->subtext()->kirbytext() ?>
                </div>

                <div class="col-md-12 text ftco-animate">
                    <?php
                        $related = $page->related()->toPages();
                        if ($related->count() > 0):
                    ?>
                    
                        <?php foreach($related as $article): ?>
                            <a href="<?= $article->url() ?>" class="btn btn-primary">
                                <?= $article->title() ?>
                            </a>
                        <?php endforeach ?>
                    
                    <?php endif ?>
                </div>
            </div>



            <div class="col-xl-4 sidebar ftco-animate bg-light pt-5">

                        
                <div class="sidebar-box ftco-animate">
                
                            <h3 class="sidebar-heading"><a href="actualites">Actualités récentes</a></h3>

                            <?php if ($actualitesPage = page('actualites')): ?>
                            
                            
                                <?php foreach ($articles = $actualitesPage->children()->listed()->flip()->paginate(3) as $actualite): ?>

                                <div class="card bg-light border-0">

                                    <div class="card-body p-0 mb-4">
                                        <h4 class="card-title"><a href="<?= $actualite->url() ?>"><?= $actualite->title()?></a></h4>

                                        <small class="pb_color-dark-opacity-3 font-weight-bold">Publiée en <?=  $actualite->date()->toDate('%B') ?></small><br/>

                                        <?= $actualite->text()->kirbytext()->excerpt(150) ?>
                                        
                                        <a href="<?= $actualite->url() ?>" class="btn btn-primary btn-sm m-3">Lire la suite</a>
                                    </div>
                                </div>

                                <?php endforeach ?>
                           
                            <?php endif ?>
                
                
                </div>
                <div class="sidebar-box ftco-animate">
                    <h3 class="sidebar-heading"><?= $page->aside_title()->html() ?></h3>

                    <ul class="list-unstyled">
                        <?php foreach($page->children() as $item): ?>
                        <li class="list-item py-2">
                            <a<?php e($item->isOpen(), ' class="active"') ?> href="<?= $item->url() ?>"><?= $item->title()->html() ?></a>

                                <?php
                                    // obtenir tous les enfants pour l'élément de menu actuel
                                    $children = $item->children();
                                  ?>

                                <ul>
                                    <?php foreach($children as $child): ?>
                                    <li>
                                        <a<?php e($child->isOpen(), ' class="active"') ?> href="<?= $child->url() ?>"><?= $child->title()->html() ?></a>
                                    </li>
                                    <?php endforeach ?>
                                </ul>
                        </li>
                        <?php endforeach ?>
                    </ul>

                </div>
                <!--
                <div class="sidebar-box ftco-animate">
                    <h3 class="sidebar-heading">Paragraph</h3>
                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ducimus itaque, autem necessitatibus voluptate quod mollitia delectus aut.</p>
                </div>
-->
            </div><!-- END COL -->


        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
