<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php snippet('header') ?>

<!--DEFAULT-->
DEFAULT_PAGE
<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>

                    <div class="col-md-12 d-flex align-items-center">
                        <div class="text ftco-animate">
                            <h1><?= $page->headline()->html() ?></h1>
                            <?= $page->text()->kirbytext() ?>
                        </div>
                    </div>

                    <div class="d-flex flex-row flex-wrap justify-content-center">
                        <?php snippet('files/images') ?>
                    </div>

                    <?php if(
                        $page->subtitle()->length() > 0 or
                        $page->subtext()->length() > 0
                    ): ?>
                    <div class="col-md-12 d-flex bg-light align-items-center">
                        <div class="text ftco-animate">
                            <h2><?= $page->subtitle()->html() ?></h2>
                            <p><?= $page->subtext()->kirbytext() ?></p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

            </div>
        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
