<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php snippet('header') ?>

<!--CREATION LEFT-->

<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row d-flex">
            <div class="col-xl-8 py-5 px-md-5">
                <div class="col-12 mb-5">
                    <?php snippet('breadcrumb') ?>
                </div>
                <div class="col-md-12 d-flex align-items-center">
                    <div class="text ftco-animate">
                        <h1><?= $page->title()->html() ?></h1>
                    </div>
                </div>

                <div class="d-flex flex-row flex-wrap justify-content-center">
                    <?php snippet('files/images') ?>
                </div>

                <div class="col-md-12 text ftco-animate">

                    <?= $page->text()->kirbytext() ?>

                </div>
            </div>



            <div class="col-xl-4 sidebar ftco-animate bg-light pt-5">



                <div class="sidebar-box ftco-animate">
                    <h3 class="sidebar-heading"><?= $page->subtitle()->html() ?></h3>

                    <ul class="list-unstyled">
                        <?php foreach($page->children() as $item): ?>
                        <li class="list-item py-2">
                            <a<?php e($item->isOpen(), ' class="active"') ?> href="<?= $item->url() ?>"><?= $item->title()->html() ?></a>

                                <?php
                                    // obtenir tous les enfants pour l'élément de menu actuel
                                    $children = $item->children();
                                  ?>

                                <ul>
                                    <?php foreach($children as $child): ?>
                                    <li>
                                        <a<?php e($child->isOpen(), ' class="active"') ?> href="<?= $child->url() ?>"><?= $child->title()->html() ?></a>
                                    </li>
                                    <?php endforeach ?>
                                </ul>
                        </li>
                        <?php endforeach ?>
                    </ul>

                </div>
                <!--
                <div class="sidebar-box ftco-animate">
                    <h3 class="sidebar-heading">Paragraph</h3>
                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ducimus itaque, autem necessitatibus voluptate quod mollitia delectus aut.</p>
                </div>
-->
            </div><!-- END COL -->


        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
