<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php snippet('header') ?>

<!--CONTACT-->

<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>

                    <div class="col-md-12 d-flex align-items-center">
                        <div class="text ftco-animate">
                            <h1><?= $page->headline()->html() ?></h1>
                            <?= $page->text()->kirbytext() ?>
                        </div>
                    </div>

                    <!-- Début formulaire SUCCESS -->


                    <?php if($success): ?>

                    <div class="alert alert-success alert-dismissible fade show" role="alert" data-delay="100" id="myAlert">
                        <strong><?= $success ?></strong>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>


                    <?php else: ?>


                    <!-- Fin formulaire SUCCESS -->

                    <div class="col-md-12 d-flex flex-row flex-wrap justify-content-center">
                        <!-- Début formulaire -->

                        <?php if (isset($alert['error'])): ?>
                        <div><?= $alert['error'] ?></div>
                        <?php endif ?>

                        <form method="POST" action="<?= $page->url() ?>/">
                            <div class="row">
                                <div class="honeypot">
                                    <label for="website">Website <abbr title="required">*</abbr></label>
                                    <input type="website" id="website" name="website">
                                </div>

                                <div class="col-md">
                                    <div class="form-group">
                                        <label for="name">Nom <abbr title="required">*</abbr></label>
                                        <input type="text" id="name" name="name" value="<?= $data['name'] ?? '' ?>" class="form-control p-3 rounded-0" required>
                                        <?= isset($alert['name']) ? '<span class="alert error">' . html($alert['name']) . '</span>' : '' ?>
                                    </div>
                                </div>
                                <div class="col-md">
                                    <div class="form-group">
                                        <label for="email">Email <abbr title="required">*</abbr></label>
                                        <input type="email" id="email" name="email" value="<?= $data['email'] ?? '' ?>" class="form-control p-3 rounded-0" required>
                                        <?= isset($alert['email']) ? '<span class="alert error">' . html($alert['email']) . '</span>' : '' ?>
                                    </div>
                                </div>
                                <div class="col-md">
                                    <div class="form-group">
                                        <label for="phone">Téléphone <abbr title="required">*</abbr></label>
                                        <input type="text" id="phone" name="phone" value="<?= $data['phone'] ?? '' ?>" class="form-control p-3 rounded-0" required>
                                        <?= isset($alert['phone']) ? '<span class="alert error">' . html($alert['phone']) . '</span>' : '' ?>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="text">Message <abbr title="required">*</abbr></label>
                                <textarea id="text" name="text" rows="10" class="form-control  p-3 rounded-0" required><?= $data['text']?? '' ?></textarea><?= isset($alert['text']) ? '<span class="alert error">' . html($alert['text']) . '</span>' : '' ?>
                            </div>
                            
                            <div class="form-group form-check">
                                <input type="checkbox" id="checkboxvalid" name="checkboxvalid" class="form-check-input" value="confirmée"<?php e(!$data['checkboxvalid']=='' || $data['checkboxvalid']=='confirmée', ' checked')?> required>
                                
                                <label for="checkboxvalid">En cochant cette case j'accepte que les informations saisies soient exploitées dans le cadre de la relation qui peut en découler.</label>
                                <?= isset($alert['checkboxvalid']) ? '<span class="alert error">' . html($alert['checkboxvalid']) . '</span>' : '' ?>
                            </div>
                            
                            <div class="form-group">
                                <input type="submit" name="submit" class="btn btn-primary" value="Envoyez">
                            </div>
                        </form>
                        <?php endif ?>
                        <!-- fin formulaire -->

                    </div>


                </div>

            </div>
        </div><!-- END-->
    </div>
</section>



<?php snippet('footer') ?>
