<?php
/**
 * Templates render the content of your pages. 
 * They contain the markup together with some control structures like loops or if-statements.
 * The `$page` variable always refers to the currently active page. 
 * To fetch the content from each field we call the field name as a method on the `$page` object, e.g. `$page->title()`. * 
 * This default template must not be removed. It is used whenever Kirby cannot find a template with the name of the content file.
 * Snippets like the header, footer and intro contain markup used in multiple templates. They also help to keep templates clean.
 * More about templates: https://getkirby.com/docs/guide/templates/basics
 */
?>

<?php snippet('header') ?>

<!--PAGE BLOG -->

<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>

                    <div class="col-12 mb-5">
                        <h1><?= $page->headline() ?></h1>
                        <?= $page->text()->kirbytext() ?>
                    </div>

                    <div class="col-md-12">
                        <!-- blog -->
                        <?php if ($actualitesPage = page()): ?>

                            <?php foreach ($articles = $actualitesPage->children()->listed()->flip()->paginate(10) as $actualite):
                                ?>
                            <div class="row mb-5">
                                <div class="col-lg-12">
                                    <small class="text-uppercase"><?= $actualite->date()->toDate('%A %e %B à %H:%M') ?></small>

                                    <h2><a href="<?= $actualite->url() ?>"><?= $actualite->title() ?></a></h2>
                                    <p><?= $actualite->text() ?></p>
                                </div>
                            </div>

                        <?php endforeach ?>

                        <?php endif ?>

                    </div>


                    <div class="col-md-12 d-flex bg-light align-items-center">
                        <div class="text ftco-animate">
                            <!-- Pagination -->
                            <?php if ($articles->pagination()->hasPages()): ?>
                            <nav class="pagination">

                                <?php if ($articles->pagination()->hasNextPage()): ?>
                                <a class="next" href="<?= $articles->pagination()->nextPageURL() ?>">
                                    suivant ›
                                </a>
                                <?php endif ?>

                                <?php if ($articles->pagination()->hasPrevPage()): ?>
                                <a class="prev" href="<?= $articles->pagination()->prevPageURL() ?>">
                                    ‹ précédent
                                </a>
                                <?php endif ?>

                            </nav>
                            <?php endif ?>
                            <!-- fin Pagination -->
                        </div>
                    </div>

                </div>

            </div>
        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
