<?php snippet('header') ?>

<!--PAGE BLOG-->
<section class="ftco-section ftco-no-pt ftco-no-pb">
    <div class="container">
        <?php snippet('logo-entete'); ?>

        <div class="row py-5 px-md-5">
            <div class="col-md-12">
                <div class="row d-flex">

                    <div class="col-12 mb-5">
                        <?php snippet('breadcrumb') ?>
                    </div>


                    <div class="col-lg-12">
                        <h1><?= $page->title()->html() ?></h1>

                        <small class="text-uppercase font-weight-bold"><?= $page->date()->toDate('%A %e %B à %H:%M') ?></small>

                        <?= $page->text()->kirbytext() ?>

                        VIDEO:
                        <?php
                        if($embed = $page->myfield()->toEmbed()) {
                            echo $embed->code();
                            echo $embed->title();
                        }
                    ?>


                    </div>
                    <?php foreach($page->images() as $image): ?>
                    <div class="col">

                        <a href="<?= $image->url() ?>" class="pb_hover-zoom image-popup" title="<?= $image->title() ?>">
                            <img src="<?= $image->url() ?>" class="img-fluid rounded" alt="<?= $image->alt() ?>" title="<?= $image->title() ?>">

                            <i class="ion-ios-search-strong icon"></i>
                        </a>
                        <small>
                            <a class="text-link" data-container="body" data-toggle="popover" data-placement="bottom" data-content="<?= $image->title() ?>">
                                <?= $image->title()->excerpt(85) ?>
                            </a>
                        </small>
                    </div>
                    <?php endforeach ?>



                    <div class="col-md-12 d-flex bg-light align-items-center m-3 p-3">
                        <div class="text ftco-animate">

                            <h2>Actualités récentes</h2>

                            <?php if ($actualitesPage = page('actualites')): ?>
                            <div class="card-deck">

                                <?php foreach ($articles = $actualitesPage->children()->listed()->flip()->paginate(3) as $actualite): ?>

                                <div class="card border-0">

                                    <div class="card-body">
                                        <h4 class="card-title"><a href="<?= $actualite->url() ?>"><?= $actualite->title()?></a></h4>

                                        <small class="text-uppercase pb_color-dark-opacity-3 font-weight-bold"><?=  $actualite->date()->toDate('%A %e %B à %H:%M') ?></small>


                                        <?php if ($actualite->hasImages()): ?>
                                        <a href="<?= $actualite->url() ?>"><img class="card-img-top" src="<?=  $site->url() ?>/<?= $actualite->images() ?>" alt="<?= $actualite->title() ?>" width="100%"></a>
                                        <?php else: ?>
                                        <a href="<?= $actualite->url() ?>"><img class="card-img-top" src="<?=  $site->url() ?>/assets/images/logo.jpg" alt="" width="100%"></a>
                                        <?php endif ?>

                                    </div>
                                </div>

                                <?php endforeach ?>
                            </div>
                            <?php endif ?>

                        </div>
                    </div>

                </div>

            </div>
        </div><!-- END-->
    </div>
</section>

<?php snippet('footer') ?>
