<?php
/*
  Snippets are a great way to store code snippets for reuse
  or to keep your templates clean.

  The note snippet renders an excerpt of a blog article.

  More about snippets:
  https://getkirby.com/docs/guide/templates/snippets
*/
?>
<article class="note-excerpt mb-4">
    <header>
        <h2 class="note-excerpt-title"><?= $note->title() ?></h2>
        <time class="note-excerpt-date" datetime="<?= $note->published('c') ?>"><?= $note->date()->toDate('%A %e %B à %H:%M') ?></time>
    </header>
    <?php if (($excerpt ?? true) !== false): ?>
    <div class="note-excerpt-text">
        <?= $note->text()->toBlocks()->excerpt(280) ?><br/>
        <a href="<?= $note->url() ?>" class="btn btn-primary mt-2">Lire la suite</a>
    </div>
    <?php endif ?>
</article>
