<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title><?= $page->seotitle() ?></title>
    <meta name="description" content="<?= $page->seodescription() ?>">

    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lora:400,400i,700,700i&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Abril+Fatface&display=swap" rel="stylesheet">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?= $site->url() ?>">
    <meta property="og:title" content="<?= $page->seotitle() ?>">
    <meta property="og:description" content="<?= $page->seodescription() ?>">
    <meta property="og:image" content="<?= $site->url() ?>/assets/images/pierre-uga-piano.jpg">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?= $site->url() ?>">
    <meta property="twitter:title" content="<?= $page->seotitle() ?>">
    <meta property="twitter:description" content="<?= $page->seodescription() ?>">
    <meta property="twitter:image" content="<?= $site->url() ?>/assets/images/pierre-uga-piano.jpg">

    <!-- BASE CSS -->
    <?= css(['assets/css/base/base.css', '@auto']) ?>
    <?= css(['assets/css/base/cookie.css', '@auto']) ?>
    <?= css(['assets/css/base/form.css', '@auto']) ?>

    <!-- ICONS CSS -->
    <script defer src="https://use.fontawesome.com/releases/v5.0.10/js/all.js" integrity="sha384-slN8GvtUJGnv6ca26v8EzVaR9DC58QEwsIk9q1QXdCU8Yu8ck/tL/5szYlBbqmS+" crossorigin="anonymous"></script>
    
    <!-- CSS -->
    <?= css(['assets/css/open-iconic-bootstrap.min.css', '@auto']) ?>
    <?= css(['assets/css/animate.css', '@auto']) ?>
    <?= css(['assets/css/owl.carousel.min.css', '@auto']) ?>
    <?= css(['assets/css/owl.theme.default.min.css', '@auto']) ?>
    <?= css(['assets/css/magnific-popup.css', '@auto']) ?>
    <?= css(['assets/css/ionicons.min.css', '@auto']) ?>

    <?= css(['assets/css/bootstrap-datepicker.css', '@auto']) ?>
    <?= css(['assets/css/jquery.timepicker.css', '@auto']) ?>

    <?= css(['assets/css/flaticon.css', '@auto']) ?>
    <?= css(['assets/css/icomoon.css', '@auto']) ?>

    <!-- Animate AOS -->
    <?= css(['assets/css/aos.css', '@auto']) ?>

    <!-- Custom CSS -->
    <?= css(['assets/css/style.css', '@auto']) ?>

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <!-- code a ajouter -->


    <!--<link rel="stylesheet" href="css/ionicons.min.css">-->

</head>

<body>

    <?php snippet('cookie'); ?>
    <div id="colorlib-page">
        <a href="#" class="js-colorlib-nav-toggle colorlib-nav-toggle"><i></i></a>
        <aside id="colorlib-aside" role="complementary" class="js-fullheight">
            <div id="colorlib-logo"><a href="<?= $site->url() ?>"><img src="<?= $site->url() ?>/assets/images/logo.jpg" width="100%" /></a></div>

            <?php snippet('menu'); ?>
            
            <?php snippet('dons'); ?>
            
        </aside> <!-- END COLORLIB-ASIDE -->






        <div id="colorlib-main">
