<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
                xmlns:html="http://www.w3.org/TR/REC-html40"
                xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>XML Sitemap</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <style type="text/css">
          body {
            font-family: Helvetica, Arial, sans-serif;
            font-size: 1em;
            color: #343434;
            background-color: #dadada;
          }
          table {
            border: none;
            border-collapse: collapse;
            width: 100%;
            white-space: nowrap;
          }
          #sitemap tr.odd {
            background-color: #eee;
          }
          #sitemap tbody tr:hover {
            background-color: #ccc;
          }
          #sitemap tbody tr:hover td, #sitemap tbody tr:hover td a {
            color: #000;
          }
          #content {
            margin: 0 auto;
            width: 100%;
          }
          .expl {
            margin: 10px 3px;
            line-height: 1.3em;
          }
          .expl a {
            color: black;
            font-weight: bold;
          }
          a {
            color: #000;
            text-decoration: none;
          }
          a:visited {
            color: #777;
          }
          a:hover {
            text-decoration: underline;
          }
          td {
            font-size:1em;
          }
          th {
            text-align:left;
            padding-right:30px;
            font-size:1em;
          }
          thead th {
            border-bottom: 1px solid #000;
            cursor: pointer;
          }
        </style>
      </head>
      <body>
        <div id="content">
          <h1>XML Sitemap</h1>
          <p class="expl">
            This sitemap was generated by <a href="https://github.com/omz13/kirby3-xmlsitemap/">omz13\kirby3-xmlsitemap</a>; it contains <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/> URLs.
          </p>
          <p class="expl">
              Sitemaps are meant for consumption by search engines (you can find more information at <a href="https://www.sitemaps.org">www.sitemaps.org</a>) and this page shows the sitemap after it has been transformed into a more human-readable format.
          </p>

          <table id="sitemap" cellpadding="3">
            <thead>
              <tr>
                <th width="98%">URL</th>
<!--								<th width="5%">Priority</th> -->
                <th width="1%">Images</th>
<!--								<th width="5%">Change Freq.</th>-->
                <th width="1%">Last Change</th>
              </tr>
            </thead>
            <tbody>
              <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
              <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
              <xsl:for-each select="sitemap:urlset/sitemap:url">
                <tr>
                  <td>
                    <xsl:variable name="itemURL">
                      <xsl:value-of select="sitemap:loc"/>
                    </xsl:variable>
                    <a href="{$itemURL}">
                      <xsl:value-of select="sitemap:loc"/>
                    </a>
                  </td>
<!--									<td>
                    <xsl:value-of select="concat(sitemap:priority*100,'%')"/>
                  </td>-->
                  <td>
                    <xsl:value-of select="count(image:image)"/>
                  </td>
<!--									<td>
                    <xsl:value-of select="concat(translate(substring(sitemap:changefreq, 1, 1),concat($lower, $upper),concat($upper, $lower)),substring(sitemap:changefreq, 2))"/>
                  </td>-->
                  <td>
                    <xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(' ', substring(sitemap:lastmod,12,5)))"/>
                  </td>
                </tr>
              </xsl:for-each>
            </tbody>
          </table>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
