<?php
return function($kirby, $pages, $page) {

    $alert = null;

    if($kirby->request()->is('POST') && get('submit')) {

        // check the honeypot
        if(empty(get('website')) === false) {
            go($page->url());
            exit;
        }

        $data = [
            'name'  => get('name'),
            'email' => get('email'),
            'phone'  => get('phone'),
            'text'  => get('text'),
            'checkboxvalid'  => get('checkboxvalid')
        ];

        $rules = [
            'name'  => ['required', 'min' => 3],
            'email' => ['required', 'email'],
            'phone'  => ['required', 'num'],
            'text'  => ['required', 'min' => 3, 'max' => 3000],
            'checkboxvalid' => ['required'],
        ];

        $messages = [
            'name'  => 'Merci d\'ajouter un nom valide',
            'email' => 'Merci d\'ajouter une adresse e-mail valide',
            'phone'  => 'Merci d\'ajouter un téléphone valide',
            'text'  => 'Merci d\'écrire un texte entre 3 et 3000 caractères',
            'checkboxvalid'  => 'Merci de cocher la case'
        ];

        // some of the data is invalid
        if($invalid = invalid($data, $rules, $messages)) {
            $alert = $invalid;

            // the data is fine, let's send the email
        } else {
            try {
                $kirby->email([
                    'template' => 'contact',
                    'from'     => 'contact@assi-afri.org',
                    'replyTo'  => $data['email'],
                    'to'       => 'mickael.masset@vivaneo.fr',
                    'subject'  => 'Assi-afri.org ' . esc($data['name']) . ' vous a envoyé un message',
                    'data'     => [
                        'text'   => esc($data['text']),
                        'sender' => esc($data['name']),
                        'email'  => esc($data['email']),
                        'phone'  => esc($data['phone']),
                        'checkboxvalid'  => esc($data['checkboxvalid']),
                    ]
                ]);

            } catch (Exception $error) {
                //$alert['error'] = "Le formulaire n'a pas pu être envoyé.";
                $alert['error'] = $error->getMessage();
            }

            // no exception occured, let's send a success message
            if (empty($alert) === true) {
                $success = 'Votre message a été envoyé. Merci. Nous reviendrons vers vous bientôt !';
                $data = [];
            }
        }
    }

    return [
        'alert'   => $alert,
        'data'    => $data ?? false,
        'success' => $success ?? false
    ];
};